package acao.curso;

import javax.servlet.http.*;

import dto.LoginDTO;

import model.CursoModel;
import slave.Dominio;
import acao.Acao;

public class MostraExclusaoAlteracaoCursoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		CursoModel model = new CursoModel(login);
		Integer codigoCurso = new Integer(req.getParameter("codigoCurso"));
		try{
			req.setAttribute("curso",model.buscarCurso(codigoCurso));
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarCurso.do";
		}
		
		HttpSession secao = req.getSession();
		secao.setAttribute("codigoCurso",codigoCurso);
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/curso/alterarCurso.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/curso/visualizarCurso.jsp";
		return "/jsp/curso/excluirCurso.jsp";
	}
}
