package acao.curso;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.CursoModel;
import slave.Dominio;
import acao.Acao;

public class PesquisarCursosPopUpAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		String parametroBusca = req.getParameter("parametroBusca");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		CursoModel model = new CursoModel(login);
		
		try{
			Collection listaCursos = model.buscarCursosPorParteDoNome(parametroBusca);
			req.setAttribute("cursos",listaCursos);
			
			if(listaCursos.size()<1)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarCurso.do";
		}
		return "/jsp/curso/listarCursoPopUp.jsp";
	}
}
