package acao.diretor;

import javax.servlet.http.*;

import model.DiretorModel;
import slave.Dominio;
import validacao.ValidacaoDadosCadastraisDiretorProfessor;
import validacao.message.MessageErrorProfessor;
import acao.Acao;
import dto.DiretorDTO;
import dto.LoginDTO;

public class AlterarDadosCadastraisDiretorAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		DiretorDTO dto = new DiretorDTO();
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorProfessor mep = new MessageErrorProfessor();
		req.setAttribute("action","diretor");//serve para ajudar na validacao somente
		try{
			ValidacaoDadosCadastraisDiretorProfessor.validaDadosCadastrais(req,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/dadosCadastraisDiretor.do";
		}
		//***********************************************************************
		DiretorDTO diretor = (DiretorDTO)secao.getAttribute("diretor");
		dto.setChavePessoa(diretor.getChavePessoa());
		dto.setApelido(req.getParameter("apelido"));
		dto.setEmail(req.getParameter("email"));
		dto.setWebPessoal(req.getParameter("webPessoal"));
		dto.setMaiorTitulo(req.getParameter("maiorTitulo"));
		dto.setCodigoCurso(new Integer(req.getParameter("codigoCurso")));
		DiretorModel model = new DiretorModel(login);
		
		model.alterarDadosCadastrais(dto);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		//agora que os dados foram atualizados  necessrio atualizar os dados da secao.
		diretor = model.buscarDiretor(diretor.getChavePessoa());
		secao.setAttribute("diretor",diretor);
		return "/jsp/abertura.jsp";
	}
}
