package acao.diretor;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.DiretorModel;
import slave.Dominio;
import validacao.ValidacaoCamposProfessor;
import validacao.apoio.ApoioProfessor;
import validacao.message.MessageErrorProfessor;
import acao.Acao;
import dto.DiretorDTO;
import dto.LoginDTO;

public class AlterarDiretorAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		DiretorDTO dto = new DiretorDTO();
		
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorProfessor mep = new MessageErrorProfessor();
		ApoioProfessor ap = new ApoioProfessor();
		loadProfessorApoio(req,ap);//coloca os dados da requisicao na classe de apoio
		try{
			ValidacaoCamposProfessor.validaProfessor(ap,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirAlterarDiretor.do?chavePessoa="+secao.getAttribute("chavePessoa")+"&acao=ALTERAR";
		}
		//***********************************************************************
		
		dto.setChavePessoa((Integer)secao.getAttribute("chavePessoa"));
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		java.util.Date dtRegistro = sdf.parse(req.getParameter("dtRegistro"));
		dto.setDtRegistro(new Date(dtRegistro.getTime()));
		System.out.println(dto.getDtRegistro());System.out.println(dto.getDtRegistro());System.out.println(dto.getDtRegistro());System.out.println(dto.getDtRegistro());System.out.println(dto.getDtRegistro());
		dto.setMatriculaFuncional(req.getParameter("matriculaFuncional"));
		dto.setCodigoCurso(new Integer(req.getParameter("codigoCurso")));
		dto.setMaiorTitulo(req.getParameter("maiorTitulo"));
		dto.setSituacao(req.getParameter("situacao"));
		
		DiretorModel model = new DiretorModel(login);
		model.alterarDiretor(dto);
		Collection col = new ArrayList();
		col.add(model.buscarDiretor(dto.getChavePessoa()));
		req.setAttribute("diretores",col);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarDiretor.do";
	}
	private void loadProfessorApoio(HttpServletRequest req, ApoioProfessor ap) {
		ap.setCodigoCursoVinculo(req.getParameter("codigoCurso"));
		ap.setDtRegistro(req.getParameter("dtRegistro"));//quando eh insercao coloca a data do sistema
		ap.setMatriculaFuncional(req.getParameter("matriculaFuncional"));
		ap.setMaiorTitulo(req.getParameter("maiorTitulo"));
		ap.setSituacao(req.getParameter("situacao"));
		req.setAttribute("apoio",ap);
	}

}