package acao.diretor;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.DiretorModel;
import slave.Data;
import slave.Dominio;
import validacao.ValidacaoCamposProfessor;
import validacao.apoio.ApoioProfessor;
import validacao.message.MessageErrorProfessor;
import acao.Acao;
import dto.DiretorDTO;
import dto.LoginDTO;

public class CadastrarDiretorAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		DiretorDTO dto = new DiretorDTO();//somente os dados especificos serao setados.
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		
		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorProfessor mep = new MessageErrorProfessor();
		ApoioProfessor ap = new ApoioProfessor();
		loadProfessorApoio(req,ap);//coloca os dados da requisicao na classe de apoio
		try{
			ValidacaoCamposProfessor.validaProfessor(ap,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirCadastrarDiretor.do?chavePessoa="+secao.getAttribute("chavePessoa")+"";
		}
		//***********************************************************************
		
		
		dto.setChavePessoa((Integer)secao.getAttribute("chavePessoa"));
		
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		java.util.Date dtRegistro = sdf.parse(Data.getDataSystem("dd/MM/yyyy"));
		dto.setDtRegistro(new Date(dtRegistro.getTime()));
		dto.setMaiorTitulo(req.getParameter("maiorTitulo"));
		dto.setCodigoCurso(new Integer(req.getParameter("codigoCurso")));
		dto.setMatriculaFuncional(req.getParameter("matriculaFuncional"));
		dto.setSituacao(req.getParameter("situacao"));
		DiretorModel model = new DiretorModel(login);
		
		model.cadastrarDiretor(dto);
		
		Collection col = new ArrayList();
		col.add(model.buscarDiretor(dto.getChavePessoa()));
		req.setAttribute("diretores",col);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarDiretor.do";
	}
	private void loadProfessorApoio(HttpServletRequest req,ApoioProfessor ap){
		
		ap.setCodigoCursoVinculo(req.getParameter("codigoCurso"));
		ap.setDtRegistro(Data.getDataSystem("dd/MM/yyyy"));//quando eh insercao coloca a data do sistema
		ap.setMatriculaFuncional(req.getParameter("matriculaFuncional"));
		ap.setMaiorTitulo(req.getParameter("maiorTitulo"));
		ap.setSituacao(req.getParameter("situacao"));
		req.setAttribute("apoio",ap);
		
	}
}
