package acao.diretor;

import java.util.Collection;

import javax.servlet.http.*;

import dto.LoginDTO;

import model.CursoModel;
import model.DiretorModel;
import acao.Acao;

public class MostrarExclusaoAlteracaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		secao.setAttribute("chavePessoa",chavePessoa);//seta a chave da pessoa para atualizacao...

		DiretorModel model = new DiretorModel(login);
		req.setAttribute("diretor",model.buscarDiretor(chavePessoa));
		
		CursoModel cursoModel = new CursoModel(login);
		Collection col = cursoModel.listarTodosCursos();
		req.setAttribute("cursos",col);
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/diretor/alterarDiretor.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/diretor/visualizarDiretor.jsp";
		return "/jsp/diretor/excluirDiretor.jsp";
	}
}
