package acao.diretor;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import slave.Dominio;

import model.DiretorModel;
import acao.Acao;

public class PesquisarDiretoresAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String nomeDiretor = req.getParameter("nomeDiretor");
		String matriculaFuncional = req.getParameter("matriculaFuncional");
		DiretorModel model = new DiretorModel(login);
		
		Collection col;
		try{
			col  = model.buscaDiretores(nomeDiretor,matriculaFuncional);
			
			if(col.size()<1)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirPesquisarDiretor.do";
		}
		req.setAttribute("diretores",col);
		return "/jsp/diretor/listarDiretor.jsp";
	}

}
