package acao.disciplina;

import javax.servlet.http.*;

import model.CursoModel;
import slave.Dominio;
import validacao.apoio.ApoioDisciplina;
import validacao.message.MessageErrorDisciplina;
import acao.Acao;
import dto.CursoDTO;
import dto.LoginDTO;

public class AbrirCadastroDisciplinaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		String codigoCurso = req.getParameter("codigoCurso");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		
		CursoDTO curso=null;
		if(codigoCurso!=null){
			CursoModel modelCurso = new CursoModel(login);
			
			try{
				curso = modelCurso.buscarCurso(new Integer(codigoCurso));
			}catch (Exception e) {
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarDisciplina.do";
			}
		}
		secao.setAttribute("execucao","Cadastrar");
		
		if(curso!=null){
			secao.setAttribute("curso",curso);
			if(req.getAttribute("erro") == null){
				MessageErrorDisciplina med = new MessageErrorDisciplina();
				req.setAttribute("erro",med);
			}
			if(req.getAttribute("apoio") == null){
				ApoioDisciplina ad = new ApoioDisciplina();
				req.setAttribute("apoio",ad);
			}
			return "/jsp/disciplina/cadastrarDisciplina.jsp";
		}
		return "/pesquisarCursos.do";
	}
	
}
