package acao.disciplina;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.CursoModel;
import model.DisciplinaModel;
import slave.Dominio;
import acao.Acao;
import dto.CursoDTO;
import dto.LoginDTO;

public class AbrirPesquisaDisciplinaPopUpAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		//secao.setAttribute("contexto","Disciplina");
		//secao.setAttribute("execucao","Pesquisar");
		
		Collection col = null;
		CursoDTO curso = null;
		
		//Teste para remover o curso da sessao
		String codigoCurso = req.getParameter("codigoCurso");
		if(codigoCurso==null) 
			secao.removeAttribute("curso");
		else{
			CursoModel modelCurso = new CursoModel(login);
			
			try{
				curso = modelCurso.buscarCurso(new Integer(codigoCurso));
			}catch (Exception e) {
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarDisciplina.do";
			}
		}
		
		if(curso==null){
			col = new ArrayList();
		}else{
			DisciplinaModel model = new DisciplinaModel(login);
			
			try{
				col = model.buscarDisciplinasPorParteDoNomeECodigoDoCurso("", curso.getCodigoCurso());
			}catch (Exception e) {
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarDisciplina.do";
			}
			secao.setAttribute("curso", curso);
		}
		req.setAttribute("disciplinas",col);
		
		return "/jsp/disciplina/listarDisciplinaPopUp.jsp";
	}

}
