package acao.disciplina;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.DisciplinaModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;

public class AbrirSelecionarDisciplinaAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		DisciplinaModel model = new DisciplinaModel(login);
		Collection disciplinas = new ArrayList();	
			try{
				disciplinas = model.listarTodasDisciplinas();
			}catch (Exception e) {
				e.printStackTrace();
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/jsp/ajuda.jsp";
			}
		req.setAttribute("disciplinas",disciplinas);
		return "/jsp/disciplina/selecionarDisciplina.jsp";
	}
}
