package acao.disciplina;

import javax.servlet.http.*;

import model.DisciplinaModel;
import slave.Dominio;
import validacao.ValidacaoCamposDisciplina;
import validacao.message.MessageErrorDisciplina;
import acao.Acao;
import dto.DisciplinaDTO;
import dto.LoginDTO;

public class AlterarDisciplinaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		MessageErrorDisciplina med = new MessageErrorDisciplina();

		try{
			ValidacaoCamposDisciplina.validaDisciplina(req,med);
		}catch (Exception e) {
			req.setAttribute("erro",med);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirAlterarDisciplina.do?idDisciplina="+secao.getAttribute("idDisciplina")+"&acao=ALTERAR";
		}
		//***********************************************************************
		DisciplinaModel model = new DisciplinaModel(login);
		DisciplinaDTO dto = new DisciplinaDTO();
		dto.setNomeDisciplina(req.getParameter("nomeDisciplina"));
		dto.setObjetivo(req.getParameter("objetivo"));
		dto.setCargaHoraria(new Integer(req.getParameter("cargaHoraria")));
		dto.setNivel(new Integer(req.getParameter("nivel")));
		dto.setIdDisciplina((Integer)secao.getAttribute("idDisciplina"));
		secao.removeAttribute("idDisciplina");

		try{
			model.alterarDisciplina(dto);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirPesquisarDisciplina.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarDisciplina.do";
	}

}
