package acao.disciplina;

import javax.servlet.http.*;

import model.Curso_DisciplinaModel;
import model.DisciplinaModel;
import slave.Dominio;
import validacao.ValidacaoCamposDisciplina;
import validacao.message.MessageErrorDisciplina;
import acao.Acao;
import dto.*;
public class CadastrarDisciplinaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		

		MessageErrorDisciplina med = new MessageErrorDisciplina();

		try{
			ValidacaoCamposDisciplina.validaDisciplina(req,med);
		}catch (Exception e) {
			req.setAttribute("erro",med);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirCadastrarDisciplina.do";
		}
		//***********************************************************************
		
		HttpSession sessao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		//Curso
		CursoDTO curso = (CursoDTO)sessao.getAttribute("curso");
		
		//Disciplina
		DisciplinaModel modelDisciplina = new DisciplinaModel(login);
		
		DisciplinaDTO dtoDisciplina = new DisciplinaDTO();
		dtoDisciplina.setNomeDisciplina(req.getParameter("nomeDisciplina"));
		dtoDisciplina.setObjetivo(req.getParameter("objetivo"));
		dtoDisciplina.setCargaHoraria(new Integer(req.getParameter("cargaHoraria")));
		dtoDisciplina.setNivel(new Integer(req.getParameter("nivel")));
		try{
			modelDisciplina.cadastrarDisciplina(dtoDisciplina);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarDisciplina.do";
		}
		
		//Relacionamento Curso-Disciplina
		Curso_DisciplinaModel modelCursoDisciplina = new Curso_DisciplinaModel(login);
		Curso_DisciplinaDTO dtoCursoDisciplina = new Curso_DisciplinaDTO();
		dtoCursoDisciplina.setCodigoCurso(curso.getCodigoCurso());
		dtoCursoDisciplina.setIdDisciplina(modelDisciplina.buscarIdUltimaDisciplinaCadastrada());
		try{
			modelCursoDisciplina.cadastrarCurso_DisciplinaDAO(dtoCursoDisciplina);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarDisciplina.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarDisciplina.do";
	}
}
