package acao.disciplina;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.DisciplinaModel;
import slave.Dominio;
import acao.Acao;

public class ExcluirDisciplinaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		DisciplinaModel model = new DisciplinaModel(login);
		
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		String codigoCurso = req.getParameter("codigoCurso");
	    try{
		    model.excluir(idDisciplina);
		    
		}catch (com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException e) {
			System.out.println("Essa Disciplina est sendo usada em outras partes da Aplicao,portanto no h como remov-la sem antes desvincular essa Disciplina!!! idDisciplina["+idDisciplina+"]");
			req.setAttribute("mensagem","Essa Disciplina est sendo usada em outras partes da Aplicao,portanto no h como remov-la sem antes desvincular essa Disciplina!!!");
			e.printStackTrace();
			return "/abrirPesquisarDisciplina.do";
		}
	    catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirPesquisarDisciplina.do";
		}
	    
	    req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
	    
	    if(codigoCurso!=null)
	    	return "/abrirPesquisarDisciplina.do?codigoCurso="+codigoCurso+"";
		return "/abrirPesquisarDisciplina.do";
	}

}
