package acao.disciplina;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.DisciplinaModel;
import slave.Dominio;
import acao.Acao;

public class ListarTodasDisciplinasAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		DisciplinaModel model = new DisciplinaModel(login);
		
		Collection col=null;
		try{
			col = model.listarTodasDisciplinas();
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarDisciplina.do";
		}
		
		req.setAttribute("disciplinas",col);
		return "/jsp/disciplina/listarDisciplinas.jsp";
	}

}
