package acao.disciplina;

import javax.servlet.http.*;

import dto.LoginDTO;

import model.DisciplinaModel;
import slave.Dominio;
import acao.Acao;

public class MostraExclusaoAlteracaoDisciplinaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		DisciplinaModel model = new DisciplinaModel(login);
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		try{
			req.setAttribute("disciplina",model.buscarDisciplina(idDisciplina));
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarDisciplina.do";
		}
		
		
		HttpSession secao = req.getSession();
		secao.setAttribute("idDisciplina",idDisciplina);
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/disciplina/alterarDisciplina.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/disciplina/visualizarDisciplina.jsp";
		return "/jsp/disciplina/excluirDisciplina.jsp";
	}
}
