package acao.disciplina;

import java.util.Collection;

import javax.servlet.http.*;

import model.DisciplinaModel;
import slave.Dominio;
import acao.Acao;
import dto.CursoDTO;
import dto.LoginDTO;

public class PesquisarDisciplinasAcao implements Acao {

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession sessao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String nomeDisciplina = req.getParameter("nomeDisciplina");
		String nomeCurso = req.getParameter("nomeCurso");
		CursoDTO curso = (CursoDTO) sessao.getAttribute("curso");
		DisciplinaModel model = new DisciplinaModel(login);
		
		Collection listaDisciplinas = null;
		if (curso == null) {
			try {
				listaDisciplinas = model.buscarDisciplinasPorParteDoNomeECurso(nomeDisciplina, nomeCurso);
				req.setAttribute("disciplinas", listaDisciplinas);
			} catch (Exception e) {
				e.printStackTrace();
				req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarDisciplina.do";
			}
		} else {
			try {
				listaDisciplinas = model.buscarDisciplinasPorParteDoNomeECodigoDoCurso(nomeDisciplina, curso.getCodigoCurso());
				req.setAttribute("disciplinas", listaDisciplinas);
			} catch (Exception e) {
				e.printStackTrace();
				req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarDisciplina.do";
			}
		}
		
		if(listaDisciplinas.size()<1)
			req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		
		return "/jsp/disciplina/listarDisciplina.jsp";
	}
}