package acao.disciplina;

import java.util.Collection;

import javax.servlet.http.*;

import model.DisciplinaModel;
import questao.visao.VisaoQuestao;
import slave.Dominio;
import acao.Acao;
import dto.*;
import dto.CursoDTO;
import dto.PessoaDTO;

public class PesquisarDisciplinasPopUpAcao implements Acao {

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession sessao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		Integer perfil = (Integer)req.getSession().getAttribute("perfil");
		String nomeDisciplina = req.getParameter("nomeDisciplina");
		String nomeCurso = req.getParameter("nomeCurso");
		CursoDTO curso = (CursoDTO) sessao.getAttribute("curso");
		DisciplinaModel model = new DisciplinaModel(login);
		PessoaDTO pessoa = VisaoQuestao.carregaPessoaPeloPerfil(sessao,perfil);
		Collection listaDisciplinas = null;
		
		if (curso == null) {
			try {
				if(perfil.intValue()==Dominio.getMonitor().intValue()){
					listaDisciplinas = model.buscarDisciplinasPorParteDoNomeECursoEMonitor(nomeDisciplina, nomeCurso, pessoa.getChavePessoa());
				}else{
					listaDisciplinas = model.buscarDisciplinasPorParteDoNomeECurso(nomeDisciplina, nomeCurso);
				}
				req.setAttribute("disciplinas", listaDisciplinas);
			} catch (Exception e) {
				req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarDisciplinaPopUp.do";
			}
		}else {
			try {
				listaDisciplinas = model.buscarDisciplinasPorParteDoNomeECodigoDoCurso(nomeDisciplina, curso.getCodigoCurso());
				req.setAttribute("disciplinas", listaDisciplinas);
			} catch (Exception e) {
				req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarDisciplina.do";
			}
		}
		
		if(listaDisciplinas!=null && listaDisciplinas.size()<1)
			req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		
		return "/jsp/disciplina/listarDisciplinaPopUp.jsp";
	}
}