package acao.monitor;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.DisciplinaModel;
import validacao.apoio.ApoioMonitor;
import validacao.message.MessageErrorMonitor;
import acao.Acao;
import dto.DisciplinaDTO;
import dto.LoginDTO;

public class AbrirCadastroMonitorAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		HttpSession secao = req.getSession();
		secao.setAttribute("execucao","Cadastrar");
		secao.setAttribute("chavePessoa",chavePessoa);
		DisciplinaModel model = new DisciplinaModel(login);
		
		Collection col = model.listarTodasDisciplinas();
		req.setAttribute("disciplinas",col);
		if(req.getAttribute("erro") == null){
			MessageErrorMonitor mem = new MessageErrorMonitor();
			req.setAttribute("erro",mem);
		}
		if(req.getAttribute("apoio") == null){
			ApoioMonitor am = new ApoioMonitor();
			ArrayList list = (ArrayList)col;
			DisciplinaDTO dto = (DisciplinaDTO)list.get(0);
			am.setIdDiscplina(dto.getIdDisciplina().toString());
			req.setAttribute("apoio",am);
		}
		return "/jsp/monitor/cadastrarMonitor.jsp";
	}

}
