package acao.monitor;

import javax.servlet.http.*;

import model.MonitorModel;
import model.PessoaModel;
import slave.Dominio;
import validacao.ValidacaoDadosCadastraisMonitorAluno;
import validacao.message.MessageErrorPessoa;
import acao.Acao;
import dto.*;
import dto.MonitorDTO;
import dto.PessoaDTO;

public class AlterarDadosCadastraisMonitorAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		PessoaDTO dto = new PessoaDTO();
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorPessoa mep = new MessageErrorPessoa();
		try{
			ValidacaoDadosCadastraisMonitorAluno.validaDadosCadastrais(req,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/dadosCadastraisMonitor.do";
		}
		//***********************************************************************
		MonitorDTO monitor = (MonitorDTO)secao.getAttribute("monitor");
		dto.setChavePessoa(monitor.getChavePessoa());
		dto.setApelido(req.getParameter("apelido"));
		dto.setEmail(req.getParameter("email"));
		dto.setWebPessoal(req.getParameter("webPessoal"));
		
		PessoaModel model = new PessoaModel(login);
		model.alterarDadosCadastrais(dto);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		//agora que os dados foram atualizados  necessrio atualizar os dados da secao.
		MonitorModel modMonitor = new MonitorModel(login);
		monitor = modMonitor.buscarMonitor(monitor.getChavePessoa());
		secao.setAttribute("monitor",monitor);
		return "/jsp/abertura.jsp";
	}
}
