package acao.monitor;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.DisciplinaModel;
import model.MonitorModel;
import slave.Dominio;
import validacao.ValidacaoCamposMonitor;
import validacao.apoio.ApoioMonitor;
import validacao.message.MessageErrorMonitor;
import acao.Acao;
import dto.LoginDTO;
import dto.MonitorDTO;

public class AlterarMonitorAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		MonitorDTO dto = new MonitorDTO();
		
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");

		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorMonitor mem = new MessageErrorMonitor();
		ApoioMonitor am = new ApoioMonitor();
		loadAlunoMonitor(req,am);//coloca os dados da requisicao na classe de apoio
		try{
			ValidacaoCamposMonitor.validaMonitor(am,mem);
		}catch (Exception e) {
			req.setAttribute("erro",mem);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirAlterarMonitor.do?chavePessoa="+secao.getAttribute("chavePessoa")+"&acao=ALTERAR";
		}
		//***********************************************************************
		
		dto.setChavePessoa((Integer)secao.getAttribute("chavePessoa"));
		
		if(!req.getParameter("dtSaida").equalsIgnoreCase("indeterminada")){
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			java.util.Date dtSaida = sdf.parse(req.getParameter("dtSaida"));
			dto.setDtSaida(new Date(dtSaida.getTime()));
		}
		
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		java.util.Date dtRegistro = sdf.parse(req.getParameter("dtRegistro"));
		dto.setDtRegistro(new Date(dtRegistro.getTime()));
		
		dto.setIdDisciplina(new Integer(req.getParameter("idDisciplina")));
	
		dto.setAno(new Integer(req.getParameter("ano")));
		
		dto.setSemestre(new Integer(req.getParameter("semestre")));
		
		MonitorModel model = new MonitorModel(login);
		
		int chavePessoa = Integer.parseInt(req.getParameter("chaveAlunoAtual"));
	   	int Disciplina = Integer.parseInt(req.getParameter("idDisciplinaAtual"));
	   	int Ano = Integer.parseInt(req.getParameter("anoAtual"));
	    String Semestre= (req.getParameter("semestreAtual"));
		
	    model.alterarMonitorSemestre(dto,chavePessoa,Disciplina,Ano,Semestre);
		Collection col = new ArrayList();
		col.add(model.buscarMonitor(dto.getChavePessoa()));
		req.setAttribute("monitores",col);
		DisciplinaModel modelDis = new DisciplinaModel(login);
		req.setAttribute("disciplinas",modelDis.listarTodasDisciplinas());
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarMonitor.do";
	}
	private void loadAlunoMonitor(HttpServletRequest req, ApoioMonitor am) {
		am.setAno(req.getParameter("ano"));
		am.setSemestre(req.getParameter("semestre"));
		am.setIdDiscplina(req.getParameter("idDisciplina"));
		am.setDtRegistro(req.getParameter("dtRegistro"));
		am.setDtSaida(req.getParameter("dtSaida"));
		req.setAttribute("apoio",am);
	}
}
