package acao.monitor;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.DisciplinaModel;
import model.MonitorModel;
import slave.Data;
import slave.Dominio;
import validacao.ValidacaoCamposMonitor;
import validacao.apoio.ApoioMonitor;
import validacao.message.MessageErrorMonitor;
import acao.Acao;
import dto.LoginDTO;
import dto.MonitorDTO;

public class CadastrarMonitorAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		MonitorDTO dto = new MonitorDTO();//somente os dados especificos serao setados.
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorMonitor mem = new MessageErrorMonitor();
		ApoioMonitor am = new ApoioMonitor();
		loadAlunoMonitor(req,am);//coloca os dados da requisicao na classe de apoio
		
		try{
			ValidacaoCamposMonitor.validaMonitor(am,mem);
		
		}catch (Exception e) {
			req.setAttribute("erro",mem);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirCadastrarMonitor.do?chavePessoa="+secao.getAttribute("chavePessoa")+"";
		}
		//***********************************************************************
		dto.setChavePessoa((Integer)secao.getAttribute("chavePessoa"));
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		java.util.Date dtRegistro = sdf.parse(Data.getDataSystem("dd/MM/yyyy"));
		dto.setDtRegistro(new Date(dtRegistro.getTime()));
		
		dto.setIdDisciplina(new Integer(req.getParameter("idDisciplina")));
		dto.setAno(new Integer(req.getParameter("ano")));
		dto.setSemestre(new Integer(req.getParameter("semestre")));
		MonitorModel model = new MonitorModel(login);
		model.cadastrarMonitor(dto);
		Collection col = new ArrayList();
		col.add(model.buscarMonitor(dto.getChavePessoa()));
		req.setAttribute("monitores",col);
		
		DisciplinaModel modelDis = new DisciplinaModel(login);
		req.setAttribute("disciplinas",modelDis.listarTodasDisciplinas());
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarMonitor.do";
	}

	private void loadAlunoMonitor(HttpServletRequest req, ApoioMonitor am) {
		am.setAno(req.getParameter("ano"));
		am.setSemestre(req.getParameter("semestre"));
		am.setIdDiscplina(req.getParameter("idDisciplina"));
		if(req.getParameter("dtRegistro")== null)
			am.setDtRegistro("");
		else
			am.setDtRegistro(req.getParameter("dtRegistro"));
		if(req.getParameter("dtSaida")== null)
				am.setDtSaida("");
		else
			am.setDtSaida(req.getParameter("dtSaida"));
		req.setAttribute("apoio",am);
		}

}