package acao.monitor;

import java.util.Collection;

import javax.servlet.http.*;

import dto.LoginDTO;
import model.DisciplinaModel;
import model.MonitorModel;
import acao.Acao;

public class MostrarExclusaoAlteracaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		MonitorModel model = new MonitorModel(login);
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		Integer ano = new Integer(req.getParameter("ano"));
		String semestre = new String (req.getParameter("semestre"));
		
		req.setAttribute("monitor",model.buscarMonitorEmSemestreEspecifico(chavePessoa, idDisciplina, ano, semestre));
     	DisciplinaModel disciplinaModel = new DisciplinaModel(login);
        Collection col = disciplinaModel.listarTodasDisciplinas();
        req.setAttribute("disciplinas", col);
		HttpSession secao = req.getSession();
		secao.setAttribute("chavePessoa",chavePessoa);//seta a chave da pessoa para atualizacao...
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR")){
			pmon.model.DisciplinaModel disModel = new pmon.model.DisciplinaModel(login);
			req.setAttribute("disciplinas", disModel.listarDisciplinas());
			secao.setAttribute("chavePessoa",chavePessoa);			
			return "/jsp/monitor/alterarMonitor.jsp";
			
		}
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/monitor/visualizarMonitor.jsp";
			else{
				pmon.model.DisciplinaModel disModel = new pmon.model.DisciplinaModel(login);
				req.setAttribute("disciplinas", disModel.listarDisciplinas());
				secao.setAttribute("chavePessoa",chavePessoa);			
				return "/jsp/monitor/excluirMonitor.jsp";
		}
	}
}