package acao.monitor;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import slave.Dominio;

import model.DisciplinaModel;
import model.MonitorModel;
import acao.Acao;

public class PesquisarMonitoresAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String nomeAluno = req.getParameter("nomeMonitor");
		String matricula = req.getParameter("disciplina");
		MonitorModel model = new MonitorModel(login);
		DisciplinaModel modelDis = new DisciplinaModel(login);
		
		Collection col;
		
		try{
			col  = model.buscaMonitores(nomeAluno,matricula);
			if(col.size()<1)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirPesquisarMonitor.do";
		}
		
		try{
			req.setAttribute("disciplinas",modelDis.listarTodasDisciplinas());
		}catch (Exception e) {
			req.setAttribute("mensagem","Disciplinas no encontradas!");
			e.printStackTrace();
			return "/abrirPesquisarMonitor.do";
		}
		
		req.setAttribute("monitores",col);
		return "/jsp/monitor/listarMonitor.jsp";
	}

}
