package acao.pessoa;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import seguranca.administrador.SegurancaAministrador;
import slave.Dominio;
import validacao.message.MessageErrorPessoa;
import acao.Acao;

public class AbrirAlterarPessoaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		secao.setAttribute("execucao","Alterar");
		if(SegurancaAministrador.notAutenticado(secao)){
			req.setAttribute("mensagem",Dominio.getMensagemOperacaoNegadaPorAdministrador());
			return "/index.do";
		}
		if(req.getAttribute("erro") == null){
			MessageErrorPessoa mep = new MessageErrorPessoa();
			req.setAttribute("erro",mep);
		}
		return "/buscarPessoa.do";
	}

}
