package acao.pessoa;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import seguranca.administrador.SegurancaAministrador;
import slave.Dominio;
import acao.Acao;

public class AbrirExcluirPessoaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		secao.setAttribute("execucao","Excluir");
		if(SegurancaAministrador.notAutenticado(secao)){
			req.setAttribute("mensagem",Dominio.getMensagemOperacaoNegadaPorAdministrador());
			return "/index.do";
		}
		return "/buscarPessoa.do";
	}

}
