package acao.pessoa;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import model.LoginModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;

public class AbrirGerarNovaSenhaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		secao.setAttribute("contexto","Pessoa");
		secao.setAttribute("execucao","Nova Senha");
		
		String chavePessoa = req.getParameter("chavePessoa");
		LoginModel model = new LoginModel(login);
		LoginDTO pessoa = new LoginDTO();
		
		try{
			pessoa = model.buscarLogin(new Integer(chavePessoa));
		}catch(SQLException e){
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarPessoa.do";
		}
		
		if(pessoa.getChavePessoa()==null)
			pessoa.setChavePessoa(new Integer(req.getParameter("chavePessoa")));
		
		req.setAttribute("pessoa",pessoa);
		return "/jsp/pessoa/geraNovaSenha.jsp";
	}
	
}
