package acao.pessoa;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import seguranca.administrador.SegurancaAministrador;
import slave.Dominio;
import acao.Acao;

public class AbrirPesquisaPessoaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		if(SegurancaAministrador.notAutenticado(secao)){
			req.setAttribute("mensagem",Dominio.getMensagemOperacaoNegadaPorAdministrador());
			return "/index.do";
		}
		if((Collection)req.getAttribute("pessoas") == null){
			Collection col = new ArrayList();
			req.setAttribute("pessoas",col);
		}

		
		secao.setAttribute("execucao","Pesquisar");
		return "/jsp/pessoa/listarPessoa.jsp";
	}

}
