package acao.pessoa;

import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import model.PessoaModel;
import seguranca.administrador.SegurancaAministrador;
import slave.Dominio;
import validacao.ValidacaoCamposPessoa;
import validacao.message.MessageErrorPessoa;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;

public class AlterarPessoaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		if(SegurancaAministrador.notAutenticado(secao)){
			req.setAttribute("mensagem",Dominio.getMensagemOperacaoNegadaPorAdministrador());
			return "/index.do";
		}
		MessageErrorPessoa mep = new MessageErrorPessoa();
		try{
			ValidacaoCamposPessoa.validaPessoa(req,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirAlterarPessoa.do?chavePessoa="+secao.getAttribute("chavePessoa")+"&acao=ALTERAR";
		}
		PessoaModel model = new PessoaModel(login);
		PessoaDTO dto = new PessoaDTO();
		dto.setNomePessoa(req.getParameter("nomePessoa"));
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		java.util.Date dtNascimento = sdf.parse(req.getParameter("dtNascer"));
		dto.setDtNascer(new Date(dtNascimento.getTime()));
		
		
		dto.setChavePessoa((Integer)secao.getAttribute("chavePessoa"));
		secao.removeAttribute("chavePessoa");
		
		dto.setCpf(req.getParameter("cpf"));
		dto.setSexo(req.getParameter("sexo"));
		dto.setEmail(req.getParameter("email"));
		dto.setWebPessoal(req.getParameter("webPessoal"));
		dto.setApelido(req.getParameter("apelido"));
		dto.setSituacao(req.getParameter("situacao"));
		
		try{
			model.alterarPessoa(dto);
		}catch(SQLException e){
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarPessoa.do";
		}
		
		Collection col = new ArrayList();
		try{
			col.add(model.buscarPessoa(dto.getChavePessoa()));
		}catch(SQLException e){
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarPessoa.do";
		}
		
		req.setAttribute("pessoas",col);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarPessoa.do";
	}

}
