package acao.pessoa;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import model.PessoaModel;
import seguranca.administrador.SegurancaAministrador;
import slave.Contexto;
import slave.Dominio;
import validacao.ValidacaoCamposPessoa;
import validacao.message.MessageErrorPessoa;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;
public class CadastrarPessoaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		if(SegurancaAministrador.notAutenticado(secao)){
			req.setAttribute("mensagem",Dominio.getMensagemOperacaoNegadaPorAdministrador());
			return "/index.do";
		}
		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorPessoa mep = new MessageErrorPessoa();

		try{
			ValidacaoCamposPessoa.validaPessoa(req,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirCadastrarPessoa.do";
		}
		//***********************************************************************
		PessoaModel model = new PessoaModel(login);
		PessoaDTO dto = new PessoaDTO();
		dto.setNomePessoa(req.getParameter("nomePessoa"));
	
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		java.util.Date dtNascimento = sdf.parse(req.getParameter("dtNascer"));
		dto.setDtNascer(new Date(dtNascimento.getTime()));
		dto.setApelido(req.getParameter("apelido"));
		dto.setCpf(req.getParameter("cpf"));
		dto.setSexo(req.getParameter("sexo"));
		dto.setEmail(req.getParameter("email"));
		dto.setWebPessoal(req.getParameter("webPessoal"));
		dto.setSituacao(req.getParameter("situacao"));
		try {
			model.cadastrarPessoa(dto);
			
		} catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirPesquisarPessoa.do";
		}
		
		
		Collection col = new ArrayList();
		try {
			dto = model.getUltimoInserido();
		} catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarPessoa.do";
		}

		col.add(dto);
		req.setAttribute("pessoas",col);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		if(Contexto.notContextoPessoa(req))
			return "/roteador.do?chavePessoa="+dto.getChavePessoa();
		return "/abrirPesquisarPessoa.do";
	}

}
