package acao.pessoa;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import dto.LoginDTO;

import model.PessoaModel;
import seguranca.administrador.SegurancaAministrador;
import slave.Dominio;
import acao.Acao;

public class ExcluirPessoaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		if(SegurancaAministrador.notAutenticado(secao)){
			req.setAttribute("mensagem",Dominio.getMensagemOperacaoNegadaPorAdministrador());
			return "/index.do";
		}
		PessoaModel model = new PessoaModel(login);
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		
		try{
			model.excluir(chavePessoa);
		}catch(SQLException e){
	    	req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
	    	e.printStackTrace();
	    	return "/abrirPesquisarPessoa.do";
	    }
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarPessoa.do";
	}

}
