package acao.pessoa;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import model.LoginModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;

public class GerarNovaSenhaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
					
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		LoginModel model = new LoginModel(login); 
		
		LoginDTO dto = new LoginDTO(req.getParameter("login"),req.getParameter("novaSenha"));
		dto.setChavePessoa(new Integer(req.getParameter("chavePessoa")));
		
		
		if(dto.getChavePessoa() == null){
			req.setAttribute("mensagem","Login atual invalido ou usurio inativo!");
			return "/abrirPesquisarPessoa.do";
		}

		LoginDTO novoLogin = new LoginDTO(dto.getLogin(),req.getParameter("novaSenha"));
		if(!req.getParameter("confirmacaoSenha").equals(novoLogin.getSenha())|| novoLogin.getSenha().equalsIgnoreCase("")){
			req.setAttribute("mensagem","Parmetros Invalidos!!! Informe o valores para continuar!!!");
			return "/abrirGerarNovaSenha.do";
		}
		if(novoLogin.getSenha().length() < 4){
			req.setAttribute("mensagem","Senha invlida! A senha precisa ter no mnimo 4 caracteres.");
			return "/abrirGerarNovaSenha.do";
		}
		if(novoLogin.getSenha().length() > 10){
			req.setAttribute("mensagem","Senha invlida! A senha precisa ter no mximo 10 caracteres.");
			return "/abrirGerarNovaSenha.do";
		}
		dto.setLogin(novoLogin.getLogin());
		dto.setSenha(novoLogin.getSenha());
		
		//Vendo se usuario j  cadastrado
		LoginDTO loginBanco = model.buscarLogin(new Integer(req.getParameter("chavePessoa")));
		if(loginBanco.getChavePessoa()!=null){
			model.alterarLogin(dto);
		}else{
			try{
				model.cadastrarLogin(dto);
			}catch(SQLException e){
				e.printStackTrace();
				req.setAttribute("mensagem","Login j cadastrado no sistema!");
				return "/abrirGerarNovaSenha.do";
			}
		}
		
		secao.setAttribute("loginDTO",dto);//atualiza o logun na secao.
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/jsp/abertura.jsp";
	}
	
}
