package acao.pessoa;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import dto.LoginDTO;

import model.PessoaModel;
import slave.Dominio;
import acao.Acao;

public class MostraExclusaoAlteracaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		PessoaModel model = new PessoaModel(login);
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		try {
			req.setAttribute("pessoa",model.buscarPessoa(chavePessoa));
		} catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirPesquisarPessoa.do";
		}
		HttpSession secao = req.getSession();
		secao.setAttribute("chavePessoa",chavePessoa);
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/pessoa/alterarPessoa.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/pessoa/visualizarPessoa.jsp";
		return "/jsp/pessoa/excluirPessoa.jsp";
	}
}
