package acao.pessoa;

import java.sql.SQLException;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import dto.LoginDTO;

import model.PessoaModel;
import seguranca.administrador.SegurancaAministrador;
import slave.Contexto;
import slave.Dominio;
import acao.Acao;

public class PesquisarPessoasAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		if(SegurancaAministrador.notAutenticado(secao)){
			req.setAttribute("mensagem",Dominio.getMensagemOperacaoNegadaPorAdministrador());
			return "/index.do";
		}
		String parametroBusca = req.getParameter("parametroBusca");

		PessoaModel model = new PessoaModel(login);
		
		Collection col;
		try{
			col = model. buscarPessoasPorParteDoNome(parametroBusca);
			
			if(col.size()<1)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		}catch(SQLException e){
		 	req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
		 	e.printStackTrace();
	    	return "/abrirPesquisarPessoa.do";
		}
		req.setAttribute("pessoas",col);
		if(Contexto.notContextoPessoa(req))
			return "/roteador.do";
		return "/jsp/pessoa/listarPessoa.jsp";
	}
}
