package acao.professor;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.CursoModel;
import validacao.apoio.ApoioProfessor;
import validacao.message.MessageErrorProfessor;
import acao.Acao;
import dto.CursoDTO;
import dto.LoginDTO;

public class AbrirCadastroProfessorAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		HttpSession secao = req.getSession();
		secao.setAttribute("execucao","Cadastrar");
		secao.setAttribute("chavePessoa",chavePessoa);
		CursoModel model = new CursoModel(login);
		
		Collection col = model.listarTodosCursos();
		req.setAttribute("cursos",col);
		if(req.getAttribute("erro") == null){
			MessageErrorProfessor mep = new MessageErrorProfessor();
			req.setAttribute("erro",mep);
		}
		if(req.getAttribute("apoio") == null){
			ApoioProfessor ap = new ApoioProfessor();
			ArrayList list = (ArrayList)col;
			CursoDTO dto = (CursoDTO)list.get(0);
			ap.setCodigoCursoVinculo(dto.getCodigoCurso().toString());
			req.setAttribute("apoio",ap);
		}
		return "/jsp/professor/cadastrarProfessor.jsp";
	}

}
