package acao.professor;

import javax.servlet.http.*;

import model.ProfessorModel;
import slave.Dominio;
import validacao.ValidacaoDadosCadastraisDiretorProfessor;
import validacao.message.MessageErrorProfessor;
import acao.Acao;
import dto.LoginDTO;
import dto.ProfessorDTO;

public class AlterarDadosCadastraisProfessorAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		ProfessorDTO dto = new ProfessorDTO();
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		HttpSession secao = req.getSession();
		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorProfessor mep = new MessageErrorProfessor();
		try{
			ValidacaoDadosCadastraisDiretorProfessor.validaDadosCadastrais(req,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/dadosCadastraisProfessor.do";
		}
		//***********************************************************************
		ProfessorDTO professor = (ProfessorDTO)secao.getAttribute("professor");
		dto.setChavePessoa(professor.getChavePessoa());
		dto.setApelido(req.getParameter("apelido"));
		dto.setEmail(req.getParameter("email"));
		dto.setWebPessoal(req.getParameter("webPessoal"));
		dto.setMaiorTitulo(req.getParameter("maiorTitulo"));
		dto.setCodigoCursoVinculo(new Integer(req.getParameter("codigoCursoVinculo")));
		ProfessorModel model = new ProfessorModel(login);
		model.alterarDadosCadastrais(dto);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		//agora que os dados foram atualizados  necessrio atualizar os dados da secao.
		ProfessorModel modprofessor = new ProfessorModel(login);
		professor = modprofessor.buscarProfessor(professor.getChavePessoa());
		secao.setAttribute("professor",professor);
		return "/jsp/abertura.jsp";
	}
}
