package acao.professor;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.ProfessorModel;
import slave.Data;
import slave.Dominio;
import validacao.ValidacaoCamposProfessor;
import validacao.apoio.ApoioProfessor;
import validacao.message.MessageErrorProfessor;
import acao.Acao;
import dto.LoginDTO;
import dto.ProfessorDTO;

public class CadastrarProfessorAcao implements Acao{
	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		ProfessorDTO dto = new ProfessorDTO();//somente os dados especificos serao setados.
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		HttpSession secao = req.getSession();
		//***************parte responsavel pela validacao e mensagens e manter campos
		MessageErrorProfessor mep = new MessageErrorProfessor();
		ApoioProfessor ap = new ApoioProfessor();
		loadProfessorApoio(req,ap);//coloca os dados da requisicao na classe de apoio
		try{
			ValidacaoCamposProfessor.validaProfessor(ap,mep);
		}catch (Exception e) {
			req.setAttribute("erro",mep);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirCadastrarProfessor.do?chavePessoa="+secao.getAttribute("chavePessoa")+"";
		}
		//***********************************************************************
		dto.setChavePessoa((Integer)secao.getAttribute("chavePessoa"));
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		java.util.Date dtRegistro = sdf.parse(Data.getDataSystem("dd/MM/yyyy"));
		dto.setDtRegistro(new Date(dtRegistro.getTime()));
		dto.setMatriculaFuncional(req.getParameter("matriculaFuncional"));
		dto.setCodigoCursoVinculo(new Integer(req.getParameter("codigoCursoVinculo")));
		dto.setMaiorTitulo(req.getParameter("maiorTitulo"));
		dto.setSituacao(req.getParameter("situacao"));
		ProfessorModel pm = new ProfessorModel(login);
		pm.cadastraProfessor(dto);
		
		Collection col = new ArrayList();
		dto = pm.buscarProfessor(dto.getChavePessoa());
		col.add(dto);
		req.setAttribute("professores",col);
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarProfessor.do";
	}
	private void loadProfessorApoio(HttpServletRequest req,ApoioProfessor ap){
		
		ap.setCodigoCursoVinculo(req.getParameter("codigoCursoVinculo"));
		ap.setDtRegistro(Data.getDataSystem("dd/MM/yyyy"));//quando eh insercao coloca a data do sistema
		ap.setMatriculaFuncional(req.getParameter("matriculaFuncional"));
		ap.setMaiorTitulo(req.getParameter("maiorTitulo"));
		ap.setSituacao(req.getParameter("situacao"));
		req.setAttribute("apoio",ap);
		
	}
}
