package acao.professor;

import java.util.Collection;

import javax.servlet.http.*;

import dto.LoginDTO;

import model.CursoModel;
import model.ProfessorModel;
import acao.Acao;

public class MostrarExclusaoAlteracaoAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ProfessorModel model = new ProfessorModel(login);
		
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		req.setAttribute("professor",model.buscarProfessor(chavePessoa));
		CursoModel curModel = new CursoModel(login);
		
		Collection col = curModel.listarTodosCursos();
		req.setAttribute("cursos",col);
		HttpSession secao = req.getSession();
		secao.setAttribute("chavePessoa",chavePessoa);//seta a chave da pessoa para atualizacao...
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/professor/alterarProfessor.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/professor/visualizarProfessor.jsp";
		return "/jsp/professor/excluirProfessor.jsp";
	}
}