package acao.professor;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import slave.Dominio;

import model.ProfessorModel;
import acao.Acao;

public class PesquisarProfessoresPopUpAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String nomeProfessor = req.getParameter("nomeProfessor");
		String disciplina = req.getParameter("disciplina");
		ProfessorModel model = new ProfessorModel(login);
		Collection col;
		
		try{
			col  = model.buscaProfessores(nomeProfessor,disciplina);
			
			if(col.size()<1)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			e.printStackTrace();
			return "/abrirPesquisarDiretor.do";
		}
		req.setAttribute("professores",col);
		return "/jsp/professor/listarProfessorPopUp.jsp";
	}

}
