package acao.turma;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.*;

import model.AlunoDaTurmaModel;
import model.TurmaModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.TurmaDTO;

public class AbrirPesquisaAlunoDaTurmaAcao implements Acao {

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession(false);
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		if ((Collection) req.getAttribute("alunos") == null) {
			Collection col = new ArrayList();
			TurmaDTO turma = null;

			String codigoTurma = req.getParameter("codigoTurma");
			Integer codigoCurso = null;
			Integer idDisciplina = null;
			Integer ano = null;
			String semestre = req.getParameter("semestre");

			String codigoCursoString = req.getParameter("codigoCurso");
			if (codigoCursoString != null)
				codigoCurso = new Integer(codigoCursoString);

			String idDisciplinaString = req.getParameter("idDisciplina");
			if (codigoCursoString != null)
				idDisciplina = new Integer(idDisciplinaString);

			String anoString = req.getParameter("ano");
			if (anoString != null)
				ano = new Integer(anoString);
			
			System.out.println("teste1");
			//			Teste para remover o turma da sessao
			if (codigoTurma == null && codigoCurso == null && idDisciplina == null && ano == null
					&& semestre == null)
				secao.removeAttribute("turma");
			else {
				TurmaModel modelTurma = new TurmaModel(login);
				try {
					turma = modelTurma.buscarTurma(codigoTurma, codigoCurso, idDisciplina, ano,
							semestre);
				} catch (Exception e) {
					e.printStackTrace();
					System.out.println("teste3");
					req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
					return "/abrirPesquisarTurma.do";
				}
			}
			System.out.println("teste2");
			AlunoDaTurmaModel model = new AlunoDaTurmaModel(login);
			if (turma == null) {
				col = new ArrayList();
			} else {
				try {
					col = model.buscaAlunosDaTurma("", "", turma.getCodigoTurma(), turma
							.getCodigoCurso(), turma.getIdDisciplina(), turma.getAno(), turma
							.getSemestre());
				} catch (Exception e) {
					e.printStackTrace();
					System.out.println("teste4");
					req.setAttribute("mensagem", Dominio.getMensagemErroNaBaseDeDados());
					return "/abrirPesquisarTurma.do";
				}
				secao.setAttribute("turma", turma);
			}

			req.setAttribute("alunos", col);
		}
		secao.setAttribute("execucao", "Pesquisar");
		return "/jsp/turma/listarAlunoDaTurma.jsp";
	}

}