package acao.turma;

import javax.servlet.http.*;

import model.TurmaModel;
import slave.Dominio;
import validacao.ValidacaoCamposTurma;
import validacao.message.MessageErrorTurma;
import acao.Acao;
import dto.LoginDTO;
import dto.TurmaDTO;

public class AlterarTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		HttpSession secao = req.getSession();
		MessageErrorTurma mec = new MessageErrorTurma();

		try{
			ValidacaoCamposTurma.validaTurma(req,mec);
		}catch (Exception e) {
			req.setAttribute("erro",mec);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirAlterarTurma.do?codigoTurma="+secao.getAttribute("codigoTurma")+"&codigoCurso="+secao.getAttribute("codigoCurso")+"&idDisciplina="+secao.getAttribute("idDisciplina")+"&ano="+secao.getAttribute("ano")+"&semestre="+secao.getAttribute("semestre")+"&acao=ALTERAR";
		}
		//***********************************************************************
		TurmaModel model = new TurmaModel(login);
		TurmaDTO dto = new TurmaDTO();
		dto.setChavePessoaProfessor(new Integer(req.getParameter("chavePessoaProfessor")));
		dto.setDiaSemana(req.getParameter("diaSemana"));
		dto.setHorarioAula(req.getParameter("horarioAula"));
		dto.setTurno(req.getParameter("turno"));
		dto.setSala(req.getParameter("sala"));
		
		dto.setCodigoTurma((String)secao.getAttribute("codigoTurma"));
		dto.setCodigoCurso((Integer)secao.getAttribute("codigoCurso"));
		dto.setIdDisciplina((Integer)secao.getAttribute("idDisciplina"));
		dto.setAno((Integer)secao.getAttribute("ano"));
		dto.setSemestre((String)secao.getAttribute("semestre"));
		
		secao.removeAttribute("codigoTurma");
		secao.removeAttribute("codigoCurso");
		secao.removeAttribute("idDisciplina");
		secao.removeAttribute("ano");
		secao.removeAttribute("semestre");
		try{
			model.alterarTurma(dto);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarTurma.do";
	}

}
