package acao.turma;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.TurmaModel;
import questao.slave.DominioSemestre;
import questao.slave.UtilDate;
import slave.Dominio;
import validacao.ValidacaoCamposTurma;
import validacao.message.MessageErrorTurma;
import acao.Acao;
import dto.LoginDTO;
import dto.TurmaDTO;

public class CadastrarTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		MessageErrorTurma met = new MessageErrorTurma();

		try{
			ValidacaoCamposTurma.validaTurma(req,met);
		}catch (Exception e) {
			req.setAttribute("erro",met);
			req.setAttribute("mensagem",Dominio.getMensagemErroEntradaDeDados());
			return "/abrirCadastrarTurma.do";
		}
		//***********************************************************************
		
		TurmaModel model = new TurmaModel(login);
		TurmaDTO dto = new TurmaDTO();
		
		dto.setCodigoTurma(req.getParameter("codigoTurma"));
		dto.setCodigoCurso(new Integer(req.getParameter("codigoCurso")));
		dto.setIdDisciplina(new Integer(req.getParameter("idDisciplina")));
		//dto.setAno(new Integer(req.getParameter("ano")));
		//dto.setSemestre(req.getParameter("semestre"));
		dto.setAno(new Integer(UtilDate.getAnoAtual()));
		dto.setSemestre(DominioSemestre.getValorSemestrePelaData(UtilDate.getDataAtual()));
		dto.setChavePessoaProfessor(new Integer(req.getParameter("chavePessoaProfessor")));
		
		String[] diasDaSemana = req.getParameterValues("diaSemana");
		String diasSemanaTemp="";
		for(int i=0;i<diasDaSemana.length; i++){
			if(diasSemanaTemp.equals(""))
				diasSemanaTemp=diasDaSemana[i];
			else
				diasSemanaTemp+="-"+diasDaSemana[i];
		}
		dto.setDiaSemana(diasSemanaTemp);
		
		dto.setHorarioAula(req.getParameter("horarioAula"));
		dto.setTurno(req.getParameter("turno"));
		dto.setSala(req.getParameter("sala"));
		try{
			model.cadastrarTurma(dto);
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		
		req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarTurma.do";
	}
}
