package acao.turma;

import javax.servlet.http.*;

import model.Turma_AlunoModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.TurmaDTO;

public class ExcluirAlunoDaTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		Turma_AlunoModel model = new Turma_AlunoModel(login);
		
		HttpSession secao = req.getSession();
		TurmaDTO turma = (TurmaDTO)secao.getAttribute("turma");
		secao.removeAttribute("turma");
		Integer chavePessoa =(Integer)secao.getAttribute("chavePessoa");
	    try{
		    model.excluir(turma.getCodigoTurma(),turma.getCodigoCurso(),turma.getIdDisciplina(),turma.getAno(),turma.getSemestre() ,chavePessoa);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
	    req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarAlunoDaTurma.do?codigoTurma="+turma.getCodigoTurma()+"&codigoCurso="+turma.getCodigoCurso()+"&idDisciplina="+turma.getIdDisciplina()+"&ano="+turma.getAno()+"&semestre="+turma.getSemestre()+"";
	}
	
}
