package acao.turma;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.TurmaModel;
import slave.Dominio;
import acao.Acao;

public class ExcluirTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		TurmaModel model = new TurmaModel(login);
		
		String codigoTurma = req.getParameter("codigoTurma");
		Integer codigoCurso = new Integer(req.getParameter("codigoCurso"));
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		Integer ano = new Integer(req.getParameter("ano"));
		Integer semestre = new Integer(req.getParameter("semestre"));
	    try{
		    model.excluir(codigoTurma,codigoCurso,idDisciplina,ano,semestre);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
	    req.setAttribute("mensagem",Dominio.getMensagemSucessoOperacao());
		return "/abrirPesquisarTurma.do";
	}

}
