package acao.turma;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.TurmaModel;
import slave.Dominio;
import acao.Acao;

public class ListarTodasTurmasAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		TurmaModel model = new TurmaModel(login);
		Collection col = null;
		try{
			col = model.listarTodasTurmas();
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		req.setAttribute("turmas",col);
		return "/jsp/turma/listarTurmas.jsp";
	}

}
