package acao.turma;

import javax.servlet.http.*;

import dto.LoginDTO;

import model.TurmaModel;
import slave.Dominio;
import acao.Acao;

public class MostraExclusaoAlteracaoTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		TurmaModel model = new TurmaModel(login);
		
		String codigoTurma = req.getParameter("codigoTurma");
		Integer codigoCurso = new Integer(req.getParameter("codigoCurso"));
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		Integer ano = new Integer(req.getParameter("ano"));
		String semestre = req.getParameter("semestre");
		try{
			req.setAttribute("turma",model.buscarTurma(codigoTurma,codigoCurso,idDisciplina,ano,semestre));
		}catch (Exception e) {
			e.printStackTrace();
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		HttpSession secao = req.getSession();
		secao.setAttribute("codigoTurma",codigoTurma);
		secao.setAttribute("codigoCurso",codigoCurso);
		secao.setAttribute("idDisciplina",idDisciplina);
		secao.setAttribute("ano",ano);
		secao.setAttribute("semestre",semestre);
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/turma/alterarTurma.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/turma/visualizarTurma.jsp";
		return "/jsp/turma/excluirTurma.jsp";
	}
}
