package acao.turma;

import java.util.Collection;

import javax.servlet.http.*;

import dto.LoginDTO;

import model.AlunoModel;
import model.CursoModel;
import slave.Dominio;
import acao.Acao;

public class MostrarExclusaoAlteracaoDeAlunoDaTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		Integer chavePessoa = new Integer(req.getParameter("chavePessoa"));
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		AlunoModel model = new AlunoModel(login);
		try{
			req.setAttribute("aluno",model.buscarAluno(chavePessoa));
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		
		CursoModel cursoModel = new CursoModel(login);
		Collection col=null;
		try{
			col = cursoModel.listarTodosCursos();
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		req.setAttribute("cursos",col);
		HttpSession secao = req.getSession();
		secao.setAttribute("chavePessoa",chavePessoa);//seta a chave da pessoa para atualizacao...
		
		if(req.getParameter("acao").trim().equalsIgnoreCase("ALTERAR"))
			return "/jsp/aluno/alterarAluno.jsp";
		else if(req.getParameter("acao").trim().equalsIgnoreCase("VISUALIZAR"))
				return "/jsp/aluno/visualizarAluno.jsp";
		return "/jsp/turma/excluirAlunoDaTurma.jsp";
	}
}
