package acao.turma;

import javax.servlet.http.*;

import model.AlunoDaTurmaModel;
import slave.Dominio;
import acao.Acao;
import dto.LoginDTO;
import dto.TurmaDTO;

public class PesquisarAlunosDaTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		HttpSession sessao = req.getSession();
		String nomeAluno = req.getParameter("nomeAluno");
		String matricula = req.getParameter("matricula");
		String tipoPesquisa = req.getParameter("tipoPesquisa");
		TurmaDTO turma = (TurmaDTO)sessao.getAttribute("turma");
		AlunoDaTurmaModel model = new AlunoDaTurmaModel(login);
				
		if(turma==null || tipoPesquisa!=null){
			try{
				req.setAttribute("alunos",model.buscaAlunos(nomeAluno,matricula));
			}catch (Exception e) {
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarTurma.do";
			}
		}else{
			try{
				req.setAttribute("alunos",model.buscaAlunosDaTurma(nomeAluno,matricula,turma.getCodigoTurma(),turma.getCodigoCurso(),turma.getIdDisciplina(),turma.getAno(),turma.getSemestre()));
			}catch (Exception e) {
				req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
				return "/abrirPesquisarTurma.do";
			}
		}
		return "/jsp/turma/listarAlunoDaTurma.jsp";
	}
	
}
