package acao.turma;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.AlunoModel;
import slave.Dominio;
import acao.Acao;

public class PesquisarAlunosParaVincularTurmaAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String nomeAluno = req.getParameter("nomeAluno");
		String matricula = req.getParameter("matricula");
		AlunoModel model = new AlunoModel(login);
		Collection col  = null;
		try{
			col  = model.buscaAlunos(nomeAluno,matricula);
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		req.setAttribute("alunos",col);
		return "/jsp/turma/listarAlunoParaVincularTurma.jsp";
	}

}
