package acao.turma;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import dto.LoginDTO;

import model.TurmaModel;
import slave.Dominio;
import acao.Acao;

public class PesquisarTurmasAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		String parteCodigo = req.getParameter("parteCodigo");
		String nomeDisciplina = req.getParameter("nomeDisciplina");
		String ano = req.getParameter("anoResposta");
		String semestre = req.getParameter("semestreResposta");
		TurmaModel model = new TurmaModel(login);
		
		try{  
			Collection listaturmas = model.buscarTurmasPorCodigoEDisciplina(parteCodigo, nomeDisciplina,ano,semestre);
			req.setAttribute("turmas",listaturmas);
			
			if(listaturmas.size()<1)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
			
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		return "/jsp/turma/listarTurma.jsp";
	}
}
