package acao.turma;

import java.util.Collection;

import javax.servlet.http.*;

import model.TurmaModel;
import questao.slave.UtilDate;
import slave.Dominio;
import slave.VisaoApoioProjetoMaior;
import acao.Acao;
import dto.LoginDTO;
import dto.PessoaDTO;

public class PesquisarTurmasPopUpAcao implements Acao{

	public String executar(HttpServletRequest req, HttpServletResponse resp) throws Exception {
		HttpSession secao = req.getSession();
		String parteCodigo = req.getParameter("parteCodigo");
		String nomeDisciplina = req.getParameter("nomeDisciplina");
		String ano = req.getParameter("anoResposta");
		Integer perfil = (Integer)secao.getAttribute("perfil");
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		PessoaDTO pessoa = VisaoApoioProjetoMaior.carregaPessoaPeloPerfil(secao,perfil);
		
		if(ano==null || ano.equals(""))
			ano=new Integer(UtilDate.getAnoAtual()).toString();
		String semestre = req.getParameter("semestreResposta");
		TurmaModel model = new TurmaModel(login);
		
		try{
			Collection listaturmas = null;
			if(perfil.intValue()==Dominio.getAluno().intValue()){
				listaturmas = model.buscarTurmasPorCodigoEDisciplinaEChaveAluno(parteCodigo, nomeDisciplina,ano,semestre,pessoa.getChavePessoa().toString());
			}else if(perfil.intValue()==Dominio.getMonitor().intValue()){
				listaturmas = model.buscarTurmasPorCodigoEDisciplinaEMonitor(parteCodigo, nomeDisciplina,ano,semestre,pessoa.getChavePessoa().toString());
			}else{
				listaturmas = model.buscarTurmasPorCodigoEDisciplina(parteCodigo, nomeDisciplina,ano,semestre);
			}
			req.setAttribute("turmas",listaturmas);
			
			if(listaturmas.size()<1)
				req.setAttribute("mensagemPesquisa",Dominio.getMensagemNenhumItemEncontrado());
			
		}catch (Exception e) {
			req.setAttribute("mensagem",Dominio.getMensagemErroNaBaseDeDados());
			return "/abrirPesquisarTurma.do";
		}
		return "/jsp/turma/listarTurmaPopUp.jsp";
	}
}
